# BlueBando v3 — Laravel 11 Overlay

This is an **overlay** for a fresh Laravel 11 project. It adds multi-router, multi-gateway payments, multi-SMS,
RBAC roles (incl. Freelancer), voucher engine, jobs, reports, and i18n (English/Swahili).

## Quick Start

```bash
# 1) Create a new Laravel 11 app
composer create-project laravel/laravel bluebando-v3
cd bluebando-v3

# 2) Unzip the overlay into the project root
unzip ../BlueBando_v3_Laravel_Overlay.zip -d .  # adjust path accordingly

# 3) Install packages
composer require spatie/laravel-permission:^6 guzzlehttp/guzzle:^7 laravel/sanctum:^4 predis/predis:^2
php artisan vendor:publish --provider="Spatie\Permission\PermissionServiceProvider"

# (Optional) Auth scaffolding
composer require laravel/breeze --dev && php artisan breeze:install blade
npm install && npm run build

# 4) Env setup
cp .env .env.local || true
php artisan key:generate

# 5) Migrate & seed
php artisan migrate --seed

# 6) Queue worker & Horizon (optional)
php artisan queue:work
```

### RouterOS API
Place your `routeros_api.class.php` at `app/Routeros/vendor/routeros_api.class.php` (not included).

### Webhooks
Expose your dev server (e.g., `php artisan serve`) and configure public endpoints for gateways:
`/webhooks/payments/{provider}`

### Default Roles
- owner, admin, manager, cashier, freelancer, support

### First Login
Seeder creates an owner user: `owner@blue.local` / `password` (change in seeder before production).
