<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Order, FreelancerCommission};

class FreelancerController extends Controller
{
    public function index() {
        $orders = Order::where('user_id', auth()->id())->latest()->paginate(20);
        $earned = FreelancerCommission::where('user_id', auth()->id())->sum('computed_amount');
        return view('freelancer.index', compact('orders','earned'));
    }
    public function commissions() {
        $items = FreelancerCommission::where('user_id', auth()->id())->latest()->paginate(30);
        return view('freelancer.commissions', compact('items'));
    }
}
