<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Plan;

class PlanController extends Controller
{
    public function index() {
        $plans = Plan::latest()->paginate(20);
        return view('plans.index', compact('plans'));
    }
    public function store(Request $r) {
        $data = $r->validate([
            'name'=>'required', 'rate_limit'=>'nullable', 'validity'=>'required|integer',
            'price_tzs'=>'required|integer', 'data_cap_mb'=>'nullable|integer', 'idle_timeout'=>'nullable|integer'
        ]);
        $data['company_id'] = auth()->user()->company_id;
        Plan::create($data);
        return back()->with('ok', __('Plan saved.'));
    }
    public function update(Request $r, Plan $plan) {
        $plan->update($r->all());
        return back()->with('ok', __('Plan updated.'));
    }
    public function destroy(Plan $plan) {
        $plan->delete();
        return back()->with('ok', __('Plan removed.'));
    }
}
