<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\Sms\SmsFactory;

class SmsController extends Controller
{
    public function index() {
        return view('sms.index');
    }
    public function send(Request $r, SmsFactory $factory) {
        $data = $r->validate(['to'=>'required','message'=>'required','provider'=>'required']);
        $gw = $factory->for($data['provider']);
        $res = $gw->send($data['to'], $data['message']);
        return back()->with('ok', __('SMS sent status: ').($res->ok ? 'OK' : 'FAIL'));
    }
}
