<?php
namespace App\Models;
use Illuminate\Database\Eloquent\{Model,Factories\HasFactory,Relations\BelongsTo,Builder};

class Order extends Model
{
    use HasFactory;
    protected $fillable = ['company_id','user_id','amount','currency','gateway','status','reference','meta_json'];
    protected $casts = ['meta_json'=>'array'];
    public function scopePaid(Builder $q){ return $q->where('status','paid'); }
    public function user(): BelongsTo { return $this->belongsTo(User::class); }
}
