<?php
namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\Payments\{GatewayFactory, AzamPayAdapter, FlutterwaveAdapter, ZenoPayAdapter, SelcomAdapter, ClickPesaAdapter, PesapalAdapter};
use App\Services\Sms\{SmsFactory, BeemGateway, TwilioGateway, NextSmsGateway};

class BlueBandoServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(GatewayFactory::class, fn($app) => new GatewayFactory());
        $this->app->singleton(SmsFactory::class, fn($app) => new SmsFactory());

        // Bind concrete adapters (so they can be resolved via app())
        $this->app->singleton(AzamPayAdapter::class);
        $this->app->singleton(FlutterwaveAdapter::class);
        $this->app->singleton(ZenoPayAdapter::class);
        $this->app->singleton(SelcomAdapter::class);
        $this->app->singleton(ClickPesaAdapter::class);
        $this->app->singleton(PesapalAdapter::class);

        $this->app->singleton(BeemGateway::class);
        $this->app->singleton(TwilioGateway::class);
        $this->app->singleton(NextSmsGateway::class);
    }

    public function boot(): void
    {
        // Publish config if needed
    }
}
