<?php
namespace App\Services\Sms;

use Illuminate\Support\Facades\Http;

class BeemGateway implements SmsGateway
{
    public function send(string $to, string $message, array $meta=[]): SmsResult
    {
        $resp = Http::withBasicAuth(env('SMS_BEEM_KEY'), env('SMS_BEEM_SECRET'))
            ->asJson()->post('https://apisms.beem.africa/v1/send', [
                'source_addr' => $meta['sender'] ?? 'TEKISOFT',
                'schedule_time' => '',
                'encoding' => 0,
                'message' => $message,
                'recipients' => [['recipient_id'=>1,'dest_addr'=>$to]]
            ]);
        return new SmsResult($resp->successful(), $resp->json());
    }
}
