<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>BlueBando v3 — Verify email</title>
  <style>
    :root{--bb-panel:#111827;--bb-blue:#0ea5e9;--bb-blue-2:#3b82f6;--bb-text:#e5e7eb;--bb-dim:#9ca3af;--radius:18px;--sh:0 20px 60px rgba(0,0,0,.45)}
    *{box-sizing:border-box} html,body{height:100%}
    body{margin:0;color:var(--bb-text);background:linear-gradient(180deg,#0b1020,#0d1117);font:14px/1.45 ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;
      display:grid;place-items:center;padding:24px}
    .card{width:min(100%,560px);background:var(--bb-panel);border:1px solid rgba(148,163,184,.12);border-radius:var(--radius);box-shadow:var(--sh);padding:26px}
    .btn{width:100%;padding:14px;border-radius:14px;border:0;cursor:pointer;color:white;background:linear-gradient(135deg,var(--bb-blue-2),var(--bb-blue));box-shadow:0 10px 30px #0ea5e955,inset 0 0 0 1px rgba(255,255,255,.12);font-weight:700}
    .ok{background:#10b9811a;border:1px solid #10b98166;color:#d1fae5;padding:10px 12px;border-radius:12px;margin-top:10px;text-align:center}
    .muted{color:var(--bb-dim)}
  </style>
</head>
<body>
  <section class="card">
    <h2 style="margin:0 0 12px;font-weight:800">Verify your email</h2>
    <p class="muted">A verification link has been sent to your email address. Didn’t receive it?</p>

    @if (session('status') == 'verification-link-sent')
      <div class="ok">A new verification link has been sent to your email.</div>
    @endif

    <form method="POST" action="{{ route('verification.send') }}" style="margin-top:16px">
      @csrf
      <button class="btn" type="submit">Resend verification email</button>
    </form>

    <form method="POST" action="{{ route('logout') }}" style="margin-top:10px;text-align:center">
      @csrf
      <button type="submit" style="background:none;border:0;color:#93c5fd;cursor:pointer">Log out</button>
    </form>
  </section>
</body>
</html>