@extends('layouts.app')
@section('content')
<h1 class="text-2xl font-bold mb-4">BlueBando Checkout</h1>
<form method="post" action="{{ route('checkout.start') }}" class="p-4 bg-white rounded shadow max-w-2xl">
@csrf
  <div class="grid grid-cols-2 gap-4">
    <label class="block">Router
      <select name="router_id" class="border p-2 w-full">
        @foreach($routers as $r)
          <option value="{{ $r->id }}">{{ $r->name }} — {{ $r->host }}</option>
        @endforeach
      </select>
    </label>
    <label class="block">Plan
      <select name="plan_id" class="border p-2 w-full" id="plan">
        @foreach($plans as $p)
          <option value="{{ $p->id }}" data-price="{{ $p->price_tzs }}">{{ $p->name }} — {{ number_format($p->price_tzs) }} TZS</option>
        @endforeach
      </select>
    </label>
    <label class="block">Quantity
      <input type="number" name="qty" value="1" min="1" max="50" class="border p-2 w-full" id="qty">
    </label>
    <label class="block">Gateway
      <select name="gateway" class="border p-2 w-full">
        <option value="azam_pay">AzamPay</option>
        <option value="selcom">Selcom</option>
        <option value="flutterwave">Flutterwave</option>
        <option value="clickpesa">ClickPesa</option>
        <option value="pesapal">Pesapal</option>
        <option value="zenopay_tz">ZenoPay (TZ)</option>
      </select>
    </label>
    <label class="block col-span-2">Return URL (optional)
      <input type="url" name="return_url" placeholder="{{ url('/') }}" class="border p-2 w-full">
    </label>
  </div>
  <div class="mt-4 flex items-center justify-between">
    <div class="text-lg">Total: <span id="total">—</span> TZS</div>
    <button class="bg-blue-600 text-white px-4 py-2 rounded">Pay Now</button>
  </div>
</form>
<script>
  (function(){
    const planSel = document.getElementById('plan');
    const qtyEl = document.getElementById('qty');
    const totalEl = document.getElementById('total');
    function update(){
      const price = parseInt(planSel.options[planSel.selectedIndex].dataset.price || '0',10);
      const qty = parseInt(qtyEl.value||'1',10);
      totalEl.textContent = (price*qty).toLocaleString();
    }
    planSel.addEventListener('change', update);
    qtyEl.addEventListener('input', update);
    update();
  })();
</script>
@endsection
