@extends('layouts.app')
@section('title','Dashboard — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px">
    <h1 style="margin:0 0 6px;font-size:24px;letter-spacing:.2px">Dashboard</h1>
    <div class="muted">Quick overview of your routers, vouchers, and sales today.</div>
  </div>

  <section class="cards">
    {{-- KPIs --}}
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="server" :size="20" /></div>
        <div>
          <div class="label">Routers</div>
          <div class="value">{{ number_format($stats['routers'] ?? 0) }}</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="ticket" :size="20" /></div>
        <div>
          <div class="label">Vouchers</div>
          <div class="value">{{ number_format($stats['vouchers'] ?? 0) }}</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="banknotes" :size="20" /></div>
        <div>
          <div class="label">Sales Today ({{ config('bluebando.currency','TZS') }})</div>
          <div class="value">{{ number_format($stats['sales_today'] ?? 0) }}</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="currency-dollar" :size="20" /></div>
        <div>
          <div class="label">Currency</div>
          <div class="value">{{ config('bluebando.currency','TZS') }}</div>
        </div>
      </div>
    </div>

    {{-- Revenue sparkline --}}
    <div class="card wide">
      <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
        <strong>Last 7 Days Revenue</strong>
        <span class="muted">{{ config('bluebando.currency','TZS') }}</span>
      </div>
      <svg viewBox="0 0 600 120"
           style="width:100%;height:120px;background:var(--bb-elev);border:1px solid var(--bb-border);border-radius:12px">
        <polyline fill="none"
                  stroke="var(--bb-primary-1)" stroke-width="3"
                  points="10,90 90,70 170,82 250,60 330,65 410,40 490,50 580,42" />
        <circle cx="580" cy="42" r="4" fill="var(--bb-primary-2)"/>
      </svg>
      <div class="muted" style="font-size:12px;margin-top:6px">Hook to real data later (controller can sum paid orders by day).</div>
    </div>

    {{-- Payment mix --}}
    <div class="card wide">
      <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
        <strong>Payment Mix (Recent)</strong>
        <span class="muted">Gateways</span>
      </div>
      <div style="display:flex;gap:10px;flex-wrap:wrap">
        @php
          $mix = $mix ?? [
            ['name'=>'AzamPay','val'=>48],
            ['name'=>'Selcom','val'=>22],
            ['name'=>'Flutterwave','val'=>14],
            ['name'=>'Pesapal','val'=>9],
            ['name'=>'ClickPesa','val'=>5],
            ['name'=>'ZenoPay','val'=>2],
          ];
        @endphp
        @foreach($mix as $m)
          <div style="flex:1;min-width:140px">
            <div style="display:flex;justify-content:space-between">
              <span>{{ $m['name'] }}</span><span class="muted">{{ $m['val'] }}%</span>
            </div>
            <div style="height:8px;background:var(--bb-elev);border-radius:999px;overflow:hidden;border:1px solid var(--bb-border)">
              <div style="height:100%;width:{{ $m['val'] }}%;background:linear-gradient(90deg,var(--bb-primary-1),var(--bb-primary-2))"></div>
            </div>
          </div>
        @endforeach
      </div>
    </div>

    {{-- Recent Orders --}}
    <div class="card full">
      <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px">
        <strong>Recent Orders</strong>
        <a href="{{ url('/orders') }}" class="btn-ghost" style="text-decoration:none">View all</a>
      </div>
      @php $orders = $orders ?? \App\Models\Order::latest()->take(8)->get(); @endphp
      @if ($orders->count())
        <table>
          <thead><tr>
            <th>Reference</th><th>Gateway</th><th>Amount</th><th>Status</th><th>Date</th>
          </tr></thead>
          <tbody>
          @foreach($orders as $o)
            @php $status = strtolower($o->status); @endphp
            <tr>
              <td>{{ $o->reference }}</td>
              <td>{{ strtoupper($o->gateway) }}</td>
              <td>{{ number_format($o->amount) }} {{ $o->currency }}</td>
              <td>
                <span class="status {{ $status }}">
                  {{ ucfirst($o->status) }}
                </span>
              </td>
              <td class="muted">{{ $o->created_at->format('Y-m-d H:i') }}</td>
            </tr>
          @endforeach
          </tbody>
        </table>
      @else
        <div class="muted">No orders yet.</div>
      @endif
    </div>
  </section>
@endsection
