<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>@yield('title','BlueBando v3')</title>

  <style>
    /* =========================================================
       THEME TOKENS
       ========================================================= */
    :root{
      /* brand */
      --bb-primary-1:#3b82f6; --bb-primary-2:#0ea5e9;

      /* layout */
      --bb-bg:#0d1117;         /* page background */
      --bb-surface:#0f172a;    /* topbar/overlays */
      --bb-panel:#111827;      /* cards/panels */
      --bb-elev:#0b1220;       /* raised/inner */
      --bb-border:rgba(148,163,184,.12);

      /* text */
      --bb-text:#e5e7eb;
      --bb-dim:#9ca3af;

      /* signal */
      --bb-green:#10b981; --bb-red:#ef4444; --bb-yellow:#f59e0b;

      /* sizes */
      --radius:16px; --shadow:0 18px 60px rgba(0,0,0,.45);

      /* chrome */
      --sidebar-w:260px; --sidebar-w-collapsed:72px; --topbar-h:64px;
    }

    /* LIGHT THEME OVERRIDES */
    body.theme-light{
      --bb-bg:#f3f6fb;
      --bb-surface:#ffffff;
      --bb-panel:#ffffff;
      --bb-elev:#f7fafc;
      --bb-border:rgba(15,23,42,.08);

      --bb-text:#0b1220;
      --bb-dim:#475569;

      --shadow:0 10px 28px rgba(2,6,23,.08);
    }

    /* =========================================================
       GLOBAL BASE
       ========================================================= */
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0; color:var(--bb-text);
      background:
        radial-gradient(1200px 700px at 80% -10%, color-mix(in srgb, var(--bb-primary-2) 18%, transparent), transparent 60%),
        radial-gradient(1200px 700px at -10% 110%, color-mix(in srgb, var(--bb-primary-1) 14%, transparent), transparent 60%),
        linear-gradient(180deg, color-mix(in srgb, var(--bb-surface) 65%, transparent), var(--bb-bg));
      font: 14px/1.45 ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;
    }

    /* =========================================================
       LAYOUT + CHROME
       ========================================================= */
    .layout{display:grid; grid-template-columns: var(--sidebar-w) 1fr; min-height:100vh; transition:grid-template-columns .2s ease}
    .content{min-width:0}

    .sidebar{
      width:var(--sidebar-w);
      background: linear-gradient(180deg, color-mix(in srgb, var(--bb-surface) 92%, transparent), var(--bb-elev));
      border-right:1px solid var(--bb-border);
      transition: width .2s ease;
    }
    .nav{padding:14px}
    .nav .section{color:var(--bb-dim); font-size:11px; letter-spacing:.08em; text-transform:uppercase; margin:16px 10px 8px}
    .nav a{
      display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:12px;
      color:var(--bb-text); text-decoration:none; border:1px solid transparent;
      transition: background .15s ease, border-color .15s ease;
    }
    .nav a:hover{ background: var(--bb-elev) }
    .nav a.active{ background: color-mix(in srgb, var(--bb-surface) 92%, transparent); border-color: var(--bb-border) }
    .nav svg{opacity:.9}
    .nav .label{ transition: opacity .15s ease }

    .topbar{
      height:var(--topbar-h); display:flex; align-items:center; gap:16px; padding:0 18px;
      position:sticky; top:0; z-index:10;
      background: color-mix(in srgb, var(--bb-surface) 92%, transparent);
      backdrop-filter: blur(8px); border-bottom:1px solid var(--bb-border)
    }
    .brand-mini{display:flex;align-items:center;gap:10px}
    .brand-mini img{width:24px;height:24px}
    .top-search{flex:1; position:relative}
    .top-search svg{position:absolute; left:10px; top:50%; transform:translateY(-50%); opacity:.6}
    .user{display:flex; align-items:center; gap:10px}
    .avatar{ width:28px;height:28px;border-radius:999px; display:grid;place-items:center;
      background:var(--bb-elev); border:1px solid var(--bb-border); color:var(--bb-text); font-weight:700 }

    .footer{
      padding:14px 18px; color:var(--bb-dim);
      border-top:1px solid var(--bb-border);
      background: color-mix(in srgb, var(--bb-surface) 65%, transparent);
      margin-top:18px;
    }

    /* Cards / tables */
    .page{padding:18px}
    .cards{display:grid; grid-template-columns: repeat(12,1fr); gap:16px}
    .card{
      grid-column: span 3; background:linear-gradient(180deg, color-mix(in srgb,#fff 2%, transparent), transparent), var(--bb-panel);
      border:1px solid var(--bb-border); border-radius:var(--radius); padding:16px; box-shadow:var(--shadow)
    }
    .card.wide{grid-column: span 6}
    .card.full{grid-column:1/-1}

    .kpi{display:flex; align-items:center; gap:12px}
    .kpi .icon{width:36px;height:36px;border-radius:10px; display:grid;place-items:center; background:var(--bb-elev); border:1px solid var(--bb-border)}
    .kpi .label{font-size:12px;color:var(--bb-dim)}
    .kpi .value{font-size:22px; font-weight:800}
    .muted{color:var(--bb-dim)}

    table{width:100%; border-collapse:collapse}
    th,td{padding:10px 8px; text-align:left; border-bottom:1px solid var(--bb-border)}
    th{font-size:12px; color:var(--bb-dim); text-transform:uppercase; letter-spacing:.05em}
    .status{padding:4px 8px; border-radius:999px; font-size:12px; border:1px solid; display:inline-block}
    .paid{background: color-mix(in srgb, var(--bb-green) 12%, transparent); border-color: color-mix(in srgb, var(--bb-green) 50%, transparent); color: color-mix(in srgb, var(--bb-green) 90%, white)}
    .pending{background: color-mix(in srgb, var(--bb-yellow) 12%, transparent); border-color: color-mix(in srgb, var(--bb-yellow) 45%, transparent); color: color-mix(in srgb, var(--bb-yellow) 90%, white)}
    .failed{background: color-mix(in srgb, var(--bb-red) 12%, transparent); border-color: color-mix(in srgb, var(--bb-red) 45%, transparent); color: color-mix(in srgb, var(--bb-red) 90%, white)}

    /* Buttons */
    .btn{ background:linear-gradient(135deg, var(--bb-primary-1), var(--bb-primary-2)); color:white; border:0; padding:10px 12px; border-radius:12px; cursor:pointer }
    .btn-ghost{ background:var(--bb-elev); border:1px solid var(--bb-border); color:var(--bb-text); padding:10px 12px; border-radius:12px; cursor:pointer }
    .btn-ghost:hover{ filter: brightness(1.05) }

    /* Collapsible sidebar */
    .collapse-btn{
      position:absolute; right:-12px; top:10px; z-index:30;
      width:24px;height:24px;border-radius:999px;
      border:1px solid var(--bb-border);
      background: var(--bb-elev); color: var(--bb-text);
      display:grid;place-items:center;cursor:pointer
    }
    body.sidebar-collapsed .layout{ grid-template-columns: var(--sidebar-w-collapsed) 1fr }
    body.sidebar-collapsed .sidebar{ width:var(--sidebar-w-collapsed) }
    body.sidebar-collapsed .sidebar .section{ display:none }
    body.sidebar-collapsed .sidebar .nav a{ justify-content:center }
    body.sidebar-collapsed .sidebar .nav a .label{ opacity:0; width:0; overflow:hidden; }
    body.sidebar-collapsed .brand-title{ display:none }

    /* Collapsed tooltips */
    .nav a[data-tip]{ position:relative }
    body.sidebar-collapsed .nav a[data-tip]:hover::after{
      content: attr(data-tip);
      position:absolute; left:calc(100% + 8px); top:50%; transform:translateY(-50%);
      white-space:nowrap; background:var(--bb-surface); border:1px solid var(--bb-border);
      color:var(--bb-text); font-size:12px; padding:6px 8px; border-radius:8px; pointer-events:none;
      box-shadow:0 8px 24px rgba(0,0,0,.18);
    }

    /* Mobile */
    .s-hide{display:none}
    @media(max-width:1024px){
      .layout{grid-template-columns: 0 1fr}
      .sidebar{position:fixed; inset:0 auto 0 0; width:var(--sidebar-w); transform:translateX(-100%); transition:transform .25s; z-index:20}
      .sidebar.show{transform:translateX(0)}
      .s-hide{display:inline-flex}
      .overlay{position:fixed; inset:0; background:#0008; backdrop-filter: blur(2px); display:none}
      .overlay.show{display:block}
    }
  </style>
</head>
<body>
  <div class="layout">
    <aside id="sidebar" class="sidebar">@include('layouts.partials.sidebar')</aside>

    <div class="content">
      @include('layouts.partials.topbar')

      <div class="page">
        @yield('content')
        @include('layouts.partials.footer')
      </div>
    </div>
  </div>

  <div id="overlay" class="overlay" onclick="toggleSidebar(false)"></div>

  <script>
    function toggleSidebar(force){
      const sb = document.getElementById('sidebar');
      const ov = document.getElementById('overlay');
      const show = (typeof force==='boolean')? force : !sb.classList.contains('show');
      sb.classList.toggle('show', show);
      ov.classList.toggle('show', show);
    }
  </script>

  <script>
    // Collapsible sidebar (persist)
    (function(){
      const KEY = 'bb.sidebar.collapsed';
      const body = document.body;
      function apply(){
        const collapsed = localStorage.getItem(KEY) === '1';
        body.classList.toggle('sidebar-collapsed', collapsed);
      }
      window.bbToggleCollapse = function(){
        const v = localStorage.getItem(KEY) === '1' ? '0' : '1';
        localStorage.setItem(KEY, v);
        apply();
      };
      apply();
    })();
  </script>

  <script>
    // Theme: system/dark/light with persistence
    (function(){
      const KEY = 'bb.theme';
      const body = document.body;
      const mm = window.matchMedia('(prefers-color-scheme: dark)');

      function apply(theme){
        const mode = theme === 'system' ? (mm.matches ? 'dark' : 'light') : theme;
        body.classList.toggle('theme-light', mode === 'light');
        body.classList.toggle('theme-dark', mode === 'dark');
        body.setAttribute('data-theme', mode);
        const el = document.getElementById('theme-label');
        if(el){ el.textContent = (theme.charAt(0).toUpperCase()+theme.slice(1)); }
      }
      function current(){ return localStorage.getItem(KEY) || 'system'; }

      window.bbThemeCycle = function(){
        const order = ['system','dark','light'];
        const t = current();
        const next = order[(order.indexOf(t)+1) % order.length];
        localStorage.setItem(KEY, next);
        apply(next);
      };

      mm.addEventListener?.('change', () => { if(current()==='system') apply('system'); });
      apply(current());
    })();
  </script>
</body>
</html>