@php
  use Illuminate\Support\Facades\Route as R;
@endphp

<div style="position:relative; padding:14px 14px 6px; display:flex; align-items:center; gap:10px; border-bottom:1px solid var(--bb-border)">
  @php $logo = asset('images/bluebando-logo.svg'); @endphp
  <img src="{{ $logo }}" alt="BlueBando" width="28" height="28" onerror="this.style.display='none'">
  <div class="brand-title" style="font-weight:800; letter-spacing:.3px; font-size:15px">BlueBando v3</div>

  {{-- collapse / expand --}}
  <button type="button" class="collapse-btn" onclick="bbToggleCollapse()" title="Collapse / Expand">
    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
      <path d="M8 5l8 7-8 7"/>
    </svg>
  </button>
</div>

<nav class="nav">
  <!-- MAIN -->
  <div class="section">Main</div>

  <a data-tip="Dashboard" href="{{ R::has('dashboard') ? route('dashboard') : url('/dashboard') }}"
     class="{{ request()->routeIs('dashboard') ? 'active' : '' }}">
    <x-ico name="home" :size="20" /> <span class="label">Dashboard</span>
  </a>

  <a data-tip="Routers" href="{{ R::has('routers.index') ? route('routers.index') : url('/routers') }}"
     class="{{ request()->is('routers*') ? 'active' : '' }}">
    <x-ico name="server" :size="20" /> <span class="label">Routers</span>
  </a>

  <a data-tip="Plans" href="{{ R::has('plans.index') ? route('plans.index') : url('/plans') }}"
     class="{{ request()->is('plans*') ? 'active' : '' }}">
    <x-ico name="tag" :size="20" /> <span class="label">Plans</span>
  </a>

  <a data-tip="Vouchers" href="{{ R::has('vouchers.index') ? route('vouchers.index') : url('/vouchers') }}"
     class="{{ request()->is('vouchers*') ? 'active' : '' }}">
    <x-ico name="ticket" :size="20" /> <span class="label">Vouchers</span>
  </a>

  <!-- PAYMENTS -->
  <div class="section">Payments</div>

  <a data-tip="Checkout" href="{{ R::has('checkout.form') ? route('checkout.form') : url('/checkout') }}"
     class="{{ request()->is('checkout*') ? 'active' : '' }}">
    <x-ico name="credit-card" :size="20" /> <span class="label">Checkout</span>
  </a>

  <a data-tip="Orders" href="{{ R::has('payments.orders') ? route('payments.orders') : url('/orders') }}"
     class="{{ request()->is('orders*') ? 'active' : '' }}">
    <x-ico name="receipt-percent" :size="20" /> <span class="label">Orders</span>
  </a>

  <!-- CHANNELS -->
  <div class="section">Channels</div>

  <a data-tip="SMS Gateway" href="{{ R::has('sms.index') ? route('sms.index') : url('/sms') }}"
     class="{{ request()->is('sms*') ? 'active' : '' }}">
    <x-ico name="chat" :size="20" /> <span class="label">SMS Gateway</span>
  </a>

  <a data-tip="Freelancers" href="{{ R::has('freelancer.index') ? route('freelancer.index') : url('/freelancers') }}"
     class="{{ request()->is('freelancer*') ? 'active' : '' }}">
    <x-ico name="user-group" :size="20" /> <span class="label">Freelancers</span>
  </a>

  <!-- SYSTEM -->
  <div class="section">System</div>

  <a data-tip="Users & Roles" href="{{ R::has('users.index') ? route('users.index') : url('/users') }}"
     class="{{ request()->is('users*') ? 'active' : '' }}">
    <x-ico name="users" :size="20" /> <span class="label">Users & Roles</span>
  </a>

  <a data-tip="Settings" href="{{ R::has('settings.index') ? route('settings.index') : url('/settings') }}"
     class="{{ request()->is('settings*') ? 'active' : '' }}">
    <x-ico name="cog" :size="20" /> <span class="label">Settings</span>
  </a>

  <div class="section">Account</div>
  <form method="POST" action="{{ route('logout') }}">
    @csrf
    <button type="submit"
      style="background:none;border:0;color:var(--bb-red);padding:10px 12px;border-radius:12px;cursor:pointer;width:100%;text-align:left;display:flex;align-items:center;gap:10px">
      <x-ico name="logout" :size="20" /> <span class="label">Logout</span>
    </button>
  </form>
</nav>