@extends('layouts.app')
@section('title','Add Router — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">Add Router</h1>

  <div class="card full">
    <form method="POST" action="{{ route('routers.store') }}">
      @csrf
      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Name</label>
          <input class="input" name="name" required>
        </div>
        <div>
          <label class="label">Site</label>
          <input class="input" name="site">
        </div>
        <div>
          <label class="label">Host (IP / FQDN)</label>
          <input class="input" name="host" required>
        </div>
        <div>
          <label class="label">API Port</label>
          <input class="input" type="number" name="api_port" value="8728">
        </div>
        <div>
          <label class="label">Username</label>
          <input class="input" name="username" required>
        </div>
        <div>
          <label class="label">Password</label>
          <input class="input" type="password" name="password" required>
        </div>
        <div>
          <label class="label">TLS (Secure API)</label>
          <select class="input" name="use_tls"><option value="0">No</option><option value="1">Yes</option></select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('routers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save</button>
      </div>
    </form>
  </div>
@endsection
