@extends('layouts.app')
@section('title','Edit Router — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">Edit Router</h1>

  <div class="card full">
    <form method="POST" action="{{ route('routers.update',$router) }}">
      @csrf @method('PUT')
      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

      <div>
  <label class="label">Prefer VPN when available</label>
  <select class="input" name="prefer_vpn">
    <option value="1" @selected($router->prefer_vpn)>Yes</option>
    <option value="0" @selected(!$router->prefer_vpn)>No</option>
  </select>
  <div class="muted" style="font-size:12px;margin-top:4px">
    When enabled and a VPN IP exists, the system will connect via VPN.
  </div>
</div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ $router->name }}" required>
        </div>
        <div>
          <label class="label">Site</label>
          <input class="input" name="site" value="{{ $router->site }}">
        </div>
        <div>
          <label class="label">Host</label>
          <input class="input" name="host" value="{{ $router->host }}" required>
        </div>
        <div>
          <label class="label">API Port</label>
          <input class="input" type="number" name="api_port" value="{{ $router->api_port }}">
        </div>
        <div>
          <label class="label">Username</label>
          <input class="input" name="username" value="{{ $router->username }}" required>
        </div>
        <div>
          <label class="label">Password</label>
          <input class="input" type="password" name="password" value="{{ $router->password }}" required>
        </div>
        <div>
          <label class="label">TLS</label>
          <select class="input" name="use_tls">
            <option value="0" @selected(!$router->use_tls)>No</option>
            <option value="1" @selected($router->use_tls)>Yes</option>
          </select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('routers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Update</button>
      </div>
    </form>
  </div>
@endsection
