@extends('layouts.app')
@section('content')
<h1 class="text-xl font-semibold mb-4">Vouchers</h1>
<form method="post" action="{{ route('vouchers.generate') }}" class="p-4 bg-white rounded shadow mb-6">
  @csrf
  <div class="grid grid-cols-4 gap-3">
    <select name="router_id" class="border p-2">@foreach($routers as $r)<option value="{{ $r->id }}">{{ $r->name }}</option>@endforeach</select>
    <select name="plan_id" class="border p-2">@foreach($plans as $p)<option value="{{ $p->id }}">{{ $p->name }}</option>@endforeach</select>
    <input type="number" name="qty" class="border p-2" value="10" min="1" max="200">
    <button class="bg-blue-600 text-white px-4 py-2 rounded">Generate</button>
  </div>
</form>
<table class="w-full bg-white rounded shadow">
  <tr class="border-b"><th class="p-2">Code</th><th>Plan</th><th>Status</th><th>Sold By</th></tr>
  @foreach($vouchers as $v)
  <tr class="border-b"><td class="p-2">{{ $v->code }}</td><td>{{ optional($v->plan)->name }}</td><td>{{ $v->status }}</td><td>{{ $v->sold_by_user_id }}</td></tr>
  @endforeach
</table>
@endsection
