<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{RouterController, PlanController, VoucherController, PaymentController};
use App\Http\Controllers\RouterMetricsController;
use App\Http\Controllers\VpnController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');


// routes/web.php
Route::middleware(['auth','role:owner|admin'])->group(function(){
  Route::get('routers/{router}/vpn/create', [VpnController::class,'create'])->name('vpn.create');
  Route::post('routers/{router}/vpn', [VpnController::class,'store'])->name('vpn.store');
    Route::get('vpn/{vpn}/download',  [VpnController::class,'download'])->name('vpn.download');
  Route::post('vpn/{vpn}/revoke', [VpnController::class,'revoke'])->name('vpn.revoke');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});





// routes/web.php (wrap with middleware)
Route::middleware(['auth','role:owner|admin|manager|staff|freelancer'])->group(function(){
    Route::resource('routers', RouterController::class)->except(['show']);
    Route::get('routers/{router}/show', [RouterController::class,'show'])->name('routers.show');
    Route::get('routers/{router}/metrics', [RouterMetricsController::class,'metrics'])->name('routers.metrics');
    Route::get('routers/{router}/interfaces', [RouterMetricsController::class,'interfaces'])->name('routers.interfaces');
    Route::post('routers/{router}/poll', [RouterMetricsController::class,'pollNow'])->name('routers.poll');
});


Route::resource('routers', RouterController::class)->except(['show']);
Route::get('routers/{router}/show', [RouterController::class, 'show'])->name('routers.show');

# live/json endpoints for UI polling
Route::get('routers/{router}/metrics', [RouterMetricsController::class, 'metrics'])->name('routers.metrics');
Route::get('routers/{router}/interfaces', [RouterMetricsController::class, 'interfaces'])->name('routers.interfaces');
Route::post('routers/{router}/poll', [RouterMetricsController::class, 'pollNow'])->name('routers.poll');

require __DIR__.'/auth.php';
